﻿//////////////////////////////////////////////
// DecodedMaterialData.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Includes ---------------------------------

// nkGraphics
#include "../../Dll/DllDefines.h"

// nkMaths
#include <NilkinsMaths/Algebra/Vector.h>

/// Class ------------------------------------

namespace nkGraphics
{
	struct DLL_GRAPHICS_EXPORT TextureChannels final
	{
		bool _r = false ;
		bool _g = false ;
		bool _b = false ;
		bool _a = false ;
	} ;

	struct DLL_GRAPHICS_EXPORT DecodedMaterialData final
	{
		// Attributes
		nkMaths::Vector _ambientColor = nkMaths::Vector(1, 1, 1) ;
		int _ambientTextureIndex = -1 ;
		int _ambientTextureCoordinatesIndex = 0 ;
		TextureChannels _ambientTextureChannels ;

		nkMaths::Vector _diffuseColor = nkMaths::Vector(1, 1, 1) ;
		int _diffuseTextureIndex = -1 ;
		int _diffuseTextureCoordinatesIndex = 0 ;
		TextureChannels _diffuseTextureChannels ;

		nkMaths::Vector _specularColor = nkMaths::Vector(1, 1, 1) ;
		int _specularTextureIndex = -1 ;
		int _specularTextureCoordinatesIndex = 0 ;
		TextureChannels _specularTextureChannels ;

		nkMaths::Vector _emissiveColor = nkMaths::Vector(0, 0, 0) ;
		int _emissiveTextureIndex = -1 ;
		int _emissiveTextureCoordinatesIndex = 0 ;
		TextureChannels _emissiveTextureChannels ;

		float _roughnessFactor = 0.5f ;
		int _roughnessTextureIndex = -1 ;
		int _roughnessTextureCoordinatesIndex = 0 ;
		TextureChannels _roughnessTextureChannels ;

		float _metalnessFactor = 0.5f ;
		int _metalnessTextureIndex = -1 ;
		int _metalnessTextureCoordinatesIndex = 0 ;
		TextureChannels _metalnessTextureChannels ;

		float _glossinessFactor = 0.5f ;
		int _glossinessTextureIndex = -1 ;
		int _glossinessTextureCoordinatesIndex = 0 ;
		TextureChannels _glossinessTextureChannels ;

		float _occlusionFactor = 1.f ;
		int _occlusionTextureIndex = -1 ;
		int _occlusionTextureCoordinatesIndex = 0 ;
		TextureChannels _occlusionTextureChannels ;

		int _normalTextureIndex = -1 ;
		int _normalTextureCoordinatesIndex = 0 ;
		TextureChannels _normalTextureChannels ;

		float _alphaValue = 1.f ;
		int _alphaTextureIndex = -1 ;
		int _alphaTextureCoordinatesIndex = 0 ;
		TextureChannels _alphaTextureChannels ;
	} ;
}